## Why is this an issue?

[Caller information attributes](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/attributes/caller-information)
provide a way to get information about the caller of a method through [optional](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/named-and-optional-arguments#optional-arguments)
parameters. But they only work right if their values aren’t provided explicitly. So if you define a method with caller info attributes in the middle
of the parameter list, the caller is forced to use named arguments if they want to use the method properly.

This rule raises an issue when the following attributes are used on parameters before the end of the parameter list:

- [CallerFilePathAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerfilepathattribute)
- [CallerLineNumberAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerlinenumberattribute)
- [CallerMemberNameAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callermembernameattribute)
- [CallerArgumentExpressionAttribute](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerargumentexpressionattribute)

## How to fix it

Move the decorated parameters to the end of the parameter list.

### Code examples

#### Noncompliant code example

    void TraceMessage([CallerMemberName] string memberName = "",
      [CallerFilePath] string filePath = "",
      [CallerLineNumber] int lineNumber = 0,
      string message = null)  // Noncompliant: decorated parameters appear before "message" parameter
    {
      /* ... */
    }

#### Compliant solution

    void TraceMessage(string message = null,
      [CallerMemberName] string memberName = "",
      [CallerFilePath] string filePath = "",
      [CallerLineNumber] int lineNumber = 0)
    {
      /* ... */
    }

## Resources

### Documentation

- [Determine caller information using
  attributes interpreted by the C# compiler](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/attributes/caller-information)
- [CallerFilePathAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerfilepathattribute)
- [CallerLineNumberAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerlinenumberattribute)
- [CallerMemberNameAttribute
  Class](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callermembernameattribute)
- [CallerArgumentExpressionAttribute Class](https://learn.microsoft.com/en-us/dotnet/api/system.runtime.compilerservices.callerargumentexpressionattribute)
- [Named
  and Optional Arguments](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/named-and-optional-arguments#optional-arguments)