## Why is this an issue?

When a loop is filtering, selecting or aggregating, those functions can be handled with a clearer, more concise LINQ expression instead.

### Noncompliant code example

    var result = new List<string>();
    foreach (var element in collection)  // Noncompliant
    {
      if (condition(element))
      {
        result.Add(element);
      }
    }
    
    foreach (var element in collection2) // Noncompliant
    {
      var someValue = element.Property;
      if (someValue != null)
      {
        result.Add(someValue);
      }
    }

### Compliant solution

    var result = new List<string>();
    
    foreach (var element in collection.Where(x => condition(x)))
    {
      result.Add(element);
    }
    
    foreach (var someValue in collection2.Select(x => x.Property).Where(y => y != null))
    {
      result.Add(someValue);
    }