## Why is this an issue?

Events that are not invoked anywhere are dead code, and there’s no good reason to keep them in the source.

### Noncompliant code example

    class UninvokedEventSample
    {
        private event Action<object, EventArgs> Happened; // Noncompliant
    
        public void RegisterEventHandler(Action<object, EventArgs> handler)
        {
            Happened += handler; // we register some event handlers
        }
    
        public void RaiseEvent()
        {
            if (Happened != null)
            {
                // Happened(this, null); // the event is never triggered, because this line is commented out.
            }
        }
    }