## Why is this an issue?

Overriding methods automatically inherit the `params` behavior. To ease readability, this modifier should be explicitly used in the
overriding method as well.

### Noncompliant code example

    class Base
    {
      public virtual void Method(params int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(int[] numbers) // Noncompliant, the params is missing.
      {
        ...
      }
    }

### Compliant solution

    class Base
    {
      public virtual void Method(params int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(params int[] numbers)
      {
        ...
      }
    }