## Why is this an issue?

Since the compiler will automatically invoke the base type’s no-argument constructor, there’s no need to specify its invocation explicitly. Also,
when only a single `public` parameterless constructor is defined in a class, then that constructor can be removed because the compiler
would generate it automatically. Similarly, empty `static` constructors and empty destructors are also wasted keystrokes.

### Noncompliant code example

    class X
    {
      public X() { } // Noncompliant
      static X() { }  // Noncompliant
      ~X() { } // Noncompliant
    
      ...
    }
    
    class Y : X
    {
      public Y(int parameter) : base() // Noncompliant
      {
        /* does something with the parameter */
      }
    }

### Compliant solution

    class X
    {
      ...
    }
    
    class Y : X
    {
      public Y(int parameter)
      {
        /* does something with the parameter */
      }
    }