## Why is this an issue?

Private methods are intended for use only within their scope. If these methods return values that are not utilized by any calling functions, it
indicates that the return operation is unnecessary. Removing such returns can enhance both efficiency and code clarity.

### Noncompliant code example

    class SomeClass
    {
         private int PrivateMethod() => 42;
    
         public void PublicMethod()
         {
              PrivateMethod(); // Noncompliant: the result of PrivateMethod is not used
         }
    }