## Why is this an issue?

When you need to get external input for `set` and `init` methods defined for properties and indexers or for
`remove` and `add` methods for events, you should always get this input throught the `value` contextual keyword.

The contextual keyword `value` is similar to an input parameter of a method; it references the value that the client code is attempting
to assign to the property, indexer or event.

The keyword `value` holds the value the accessor was called with. Not using it means that the accessor ignores the caller’s intent which
could cause unexpected results at runtime.

### Noncompliant code example

    private int count;
    public int Count
    {
      get { return count; }
      set { count = 42; } // Noncompliant
    }

### Compliant solution

    private int count;
    public int Count
    {
      get { return count; }
      set { count = value; }
    }

### Exceptions

This rule doesn’t raise an issue when the setter is empty and part of the implementation of an `interface`. The assumption is that this
part of the interface is not meaningful to that particular implementation. A good example of that would be a "sink" logger that discards any logs.

## Resources

### Documentation

- [Properties](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/properties)
- [Value keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/value)
- [Add keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/add)
- [Remove keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/remove)
- [Set keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/set)