## Why is this an issue?

The rules for method resolution are complex and perhaps not properly understood by all coders. The `params` keyword can make method
declarations overlap in non-obvious ways, so that slight changes in the argument types of an invocation can resolve to different methods.

This rule raises an issue when an invocation resolves to a method declaration with `params`, but could also resolve to another
non-`params` method too.

### Noncompliant code example

    public class MyClass
    {
        private void Format(string a, params object[] b) { }
    
        private void Format(object a, object b, object c) { }
    }
    
    // ...
    MyClass myClass = new MyClass();
    
    myClass.Format("", null, null); // Noncompliant, resolves to the first Format with params, but was that intended?