## Why is this an issue?

After an `await`ed `Task` has executed, you can continue execution in the original, calling thread or any arbitrary thread.
Unless the rest of the code needs the context from which the `Task` was spawned, `Task.ConfigureAwait(false)` should be used to
keep execution in the `Task` thread to avoid the need for context switching and the possibility of deadlocks.

This rule raises an issue when code in a class library targeting .Net Framework `await`s a `Task` and continues execution in
the original calling thread.

The rule does not raise for .Net Core libraries as there is no `SynchronizationContext` in .Net Core.

### Noncompliant code example

    var response = await httpClient.GetAsync(url);  // Noncompliant

### Compliant solution

    var response = await httpClient.GetAsync(url).ConfigureAwait(false);