## Why is this an issue?

Needing to cast from an `interface` to a concrete type indicates that something is wrong with the abstractions in use, likely that
something is missing from the `interface`. Instead of casting to a discrete type, the missing functionality should be added to the
`interface`. Otherwise there is a risk of runtime exceptions.

### Noncompliant code example

    public interface IMyInterface
    {
      void DoStuff();
    }
    
    public class MyClass1 : IMyInterface
    {
      public int Data { get { return new Random().Next(); } }
    
      public void DoStuff()
      {
        // TODO...
      }
    }
    
    public static class DowncastExampleProgram
    {
      static void EntryPoint(IMyInterface interfaceRef)
      {
        MyClass1 class1 = (MyClass1)interfaceRef;  // Noncompliant
        int privateData = class1.Data;
    
        class1 = interfaceRef as MyClass1;  // Noncompliant
        if (class1 != null)
        {
          // ...
        }
      }
    }

### Exceptions

Casting to `object` doesn’t raise an issue, because it can never fail.

    static void EntryPoint(IMyInterface interfaceRef)
    {
      var o = (object)interfaceRef;
      ...
    }