## Why is this an issue?

There’s no point in chaining multiple `OrderBy` calls in a LINQ; only the last one will be reflected in the result because each
subsequent call completely reorders the list. Thus, calling `OrderBy` multiple times is a performance issue as well, because all of the
sorting will be executed, but only the result of the last sort will be kept.

Instead, use `ThenBy` for each call after the first.

### Noncompliant code example

    var x = personList
      .OrderBy(person => person.Age)
      .OrderBy(person => person.Name)  // Noncompliant
      .ToList();  // x is sorted by Name, not sub-sorted

### Compliant solution

    var x = personList
      .OrderBy(person => person.Age)
      .ThenBy(person => person.Name)
      .ToList();