## Why is this an issue?

Altering or bypassing the accessibility of classes, methods, or fields through reflection violates the encapsulation principle. This can break the
internal contracts of the accessed target and lead to maintainability issues and runtime errors.

This rule raises an issue when reflection is used to change the visibility of a class, method or field, and when it is used to directly update a
field value.

    using System.Reflection;
    
    Type dynClass = Type.GetType("MyInternalClass");
    // Noncompliant. Using BindingFlags.NonPublic will return non-public members
    BindingFlags bindingAttr = BindingFlags.NonPublic | BindingFlags.Static;
    MethodInfo dynMethod = dynClass.GetMethod("mymethod", bindingAttr);
    object result = dynMethod.Invoke(dynClass, null);

## Resources

### Documentation

- [Wikipedia definition of Encapsulation](https://en.wikipedia.org/wiki/Encapsulation_%28computer_programming%29)