## Why is this an issue?

This rule addresses the issue of incomplete assertions that can occur when using certain test frameworks. Incomplete assertions can lead to tests
that do not effectively verify anything. The rule enforces the use of complete assertions in specific cases, namely:

- Fluent Assertions: [Should()](https://fluentassertions.com/introduction) is not followed by an assertion invocation.

    string actual = "Using Fluent Assertions";
    actual.Should(); // Noncompliant

- NFluent: [Check.That()](https://www.n-fluent.net) is not followed by an assertion invocation.

    string actual = "Using NFluent";
    Check.That(actual); // Noncompliant

- NSubstitute: [Received()](https://nsubstitute.github.io/help/received-calls) is not followed by an invocation.

    command.Received(); // Noncompliant

In such cases, what is intended to be a test doesn’t actually verify anything.

## How to fix it in Fluent Assertions

`Fluent Assertions` provides an interface for writing assertions, and it is important to ensure that `Should()` is properly
used in conjunction with an assertion method.

### Code examples

#### Noncompliant code example

    string actual = "Hello World!";
    actual.Should(); // Noncompliant

#### Compliant solution

    string actual = "Hello World!";
    actual.Should().Contain("Hello");

## How to fix it in NFluent

`NFluent` offers a syntax for assertions, and it’s important to follow `Check.That()` with an assertion method to complete
the assertion.

### Code examples

#### Noncompliant code example

    string actual = "Hello World!";
    Check.That(actual); // Noncompliant

#### Compliant solution

    string actual = "Hello World!";
    Check.That(actual).Contains("Hello");

## How to fix it in NSubstitute

`NSubstitute` is a mocking framework, and `Received()` is used to verify that a specific method has been called. However,
invoking a method on the mock after calling `Received()` is necessary to ensure the complete assertion.

### Code examples

#### Noncompliant code example

    command.Received(); // Noncompliant

#### Compliant solution

    command.Received().Execute();

## Resources

### Documentation

- [Fluent assertions: Should()](https://fluentassertions.com/introduction)
- [NFluent: Check.That()](https://www.n-fluent.net)
- [NSubstitute: Received()](https://nsubstitute.github.io/help/received-calls)