## Why is this an issue?

It is possible in an `IDisposable` to call `Dispose` on class members from any method, but the contract of
`Dispose` is that it will clean up all unmanaged resources. Move disposing of members to some other method, and you risk resource
leaks.

This rule also applies for disposable ref structs.

### Noncompliant code example

    public class ResourceHolder : IDisposable
    {
      private FileStream fs;
      public void OpenResource(string path)
      {
        this.fs = new FileStream(path, FileMode.Open);
      }
      public void CloseResource()
      {
        this.fs.Close();
      }
    
      public void CleanUp()
      {
        this.fs.Dispose(); // Noncompliant; Dispose not called in class' Dispose method
      }
    
      public void Dispose()
      {
        // method added to satisfy demands of interface
      }
    }

### Compliant solution

    public class ResourceHolder : IDisposable
    {
      private FileStream fs;
      public void OpenResource(string path)
      {
        this.fs = new FileStream(path, FileMode.Open);
      }
      public void CloseResource()
      {
        this.fs.Close();
      }
    
      public void Dispose()
      {
        this.fs.Dispose();
      }
    }

## Resources

- CWE - [CWE-459 - Incomplete Cleanup](https://cwe.mitre.org/data/definitions/459)