## Why is this an issue?

When concatenating strings, it is very easy to forget a whitespace.

In some scenarios this might cause runtime errors, one of which is while creating an SQL query via concatenation:

    string select = "SELECT p.FirstName, p.LastName, p.PhoneNumber" +
            "FROM Person as p" +    // Noncompliant: concatenation results in "p.PhoneNumberFROM"
            "WHERE p.Id = @Id";     // Noncompliant: concatenation results in "pWHERE"

This rule raises an issue when the spacing around SQL keywords appears to be missing, making the concatenated string invalid SQL syntax. It would
require the user to add the appropriate whitespaces:

    string select = "SELECT p.FirstName, p.LastName, p.PhoneNumber" +
            " FROM Person as p" +
            " WHERE p.Id = @Id";