## Why is this an issue?

When the same condition is checked twice in a row, it is either confusing - why have separate checks? - or an error - some other condition should
have been checked in the second test.

### Noncompliant code example

    if (a == b)
    {
      doTheThing(b);
    }
    if (a == b) // Noncompliant; is this really what was intended?
    {
      doTheThing(c);
    }

### Compliant solution

    if (a == b)
    {
      doTheThing(b);
      doTheThing(c);
    }

or

    if (a == b)
    {
      doTheThing(b);
    }
    if (b == c)
    {
      doTheThing(c);
    }

### Exceptions

Since it is a common pattern to test a variable, reassign it if it fails the test, then re-test it, that pattern is ignored.