## Why is this an issue?

Using operator pairs (`=+`, `=-`, or `=!`) that look like reversed single operators (`+=`,
`-=` or `!=`) is confusing. They compile and run but do not produce the same result as their mirrored counterpart.

    int target = -5;
    int num = 3;
    
    target =- num;  // Noncompliant: target = -3. Is that the intended behavior?
    target =+ num; // Noncompliant: target = 3

This rule raises an issue when `=+`, `=-`, or `=!` are used without any space between the operators and when there
is at least one whitespace after.

Replace the operators with a single one if that is the intention

    int target = -5;
    int num = 3;
    
    target -= num;  // target = -8

Or fix the spacing to avoid confusion

    int target = -5;
    int num = 3;
    
    target = -num;  // target = -3