## Why is this an issue?

A `catch` clause that only rethrows the caught exception has the same effect as omitting the `catch` altogether and letting
it bubble up automatically.

    string s = "";
    try
    {
      s = File.ReadAllText(fileName);
    }
    catch (Exception e)  // Noncompliant
    {
      throw;
    }

Such clauses should either be removed or populated with the appropriate logic.

    string s = File.ReadAllText(fileName);

or

    string s = "";
    try
    {
      s = File.ReadAllText(fileName);
    }
    catch (Exception e)
    {
      logger.LogError(e);
      throw;
    }

### Exceptions

This rule will not generate issues for `catch` blocks if they are followed by a `catch` block for a more general exception
type that does more than just rethrowing the exception.

    var s = ""
    try
    {
        s = File.ReadAllText(fileName);
    }
    catch (IOException) // Compliant by exception: removing it would change the logic
    {
        throw;
    }
    catch (Exception)  // Compliant: does more than just rethrow
    {
        logger.LogError(e);
        throw;
    }