This rule raises an issue each time a `static` field is updated from a non-static method or property.

## Why is this an issue?

Updating a `static` field from a non-`static` method introduces significant challenges and potential bugs. Multiple class
instances and threads can access and modify the `static` field concurrently, leading to unintended consequences for other instances or
threads (unexpected behavior, [race conditions](https://www.c-sharpcorner.com/UploadFile/1d42da/race-conditions-in-threading-C-Sharp/) and
synchronization problems).

    class MyClass
    {
      private static int count = 0;
    
      public void DoSomething()
      {
        //...
        count++;  // Noncompliant: make the enclosing instance property 'static' or remove this set on the 'static' field.
      }
    }
    
    interface MyInterface
    {
      private static int count = 0;
    
      public void DoSomething()
      {
        //...
        count++;  // Noncompliant: remove this set, which updates a 'static' field from an instance method.
      }
    }

## Resources

### Documentation

- [Static
  Classes and Static Class Members](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/static-classes-and-static-class-members)
- [Using threads and threading](https://learn.microsoft.com/en-us/dotnet/standard/threading/using-threads-and-threading)

### Articles & blog posts

- [Race Conditions in C#](https://www.c-sharpcorner.com/UploadFile/1d42da/race-conditions-in-threading-C-Sharp/)

### Standards

- STIG Viewer - [Application Security and
  Development: V-222567](https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222567) - The application must not be vulnerable to race conditions.