## Why is this an issue?

[double.NaN](https://learn.microsoft.com/en-us/dotnet/api/system.double.nan) and [float.NaN](https://learn.microsoft.com/en-us/dotnet/api/system.single.nan) are not equal to anything, not even themselves.

When anything is compared with `NaN` using one of the [comparison operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators) `>`,
`>=`, `<`, `⇐` or the [equality operator](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators#equality-operator-)
`==`, the result will always be `false`. In contrast, when anything is compared with `NaN` using the [inequality operator](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators#inequality-operator-)
`!=`, the result will always be `true`.

Instead, the best way to see whether a variable is equal to `NaN` is to use the [float.IsNaN](https://learn.microsoft.com/en-us/dotnet/api/system.single.isnan) and [double.IsNaN](https://learn.microsoft.com/en-us/dotnet/api/system.double.isnan) methods, which work as expected.

## How to fix it

### Code examples

#### Noncompliant code example

    var a = double.NaN;
    
    if (a == double.NaN) // Noncompliant: always false
    {
      Console.WriteLine("a is not a number");
    }
    if (a != double.NaN)  // Noncompliant: always true
    {
      Console.WriteLine("a is not NaN");
    }

#### Compliant solution

    var a = double.NaN;
    
    if (double.IsNaN(a))
    {
      Console.WriteLine("a is not a number");
    }
    if (!double.IsNaN(a))
    {
      Console.WriteLine("a is not NaN");
    }