## Why is this an issue?

Having inconsistent indentation and omitting curly braces from a control structure, such as an `if` statement or `for` loop,
is misleading and can induce bugs.

This rule raises an issue when the indentation of the lines after a control structure indicates an intent to include those lines in the block, but
the omission of curly braces means the lines will be unconditionally executed once.

The following patterns are recognized:

    if (condition)
      FirstActionInBlock();
      SecondAction();  // Noncompliant: SecondAction is executed unconditionally
    ThirdAction();

    if(condition) FirstActionInBlock(); SecondAction();  // Noncompliant: SecondAction is executed unconditionally

    if (condition) FirstActionInBlock();
      SecondAction();  // Noncompliant: SecondAction is executed unconditionally

    string str = null;
    for (int i = 0; i < array.Length; i++)
      str = array[i];
      DoTheThing(str);  // Noncompliant: executed only on the last element

Note that this rule considers tab characters to be equivalent to 1 space. When mixing spaces and tabs, a code may look fine in one editor but be
confusing in another configured differently.

## Resources

- CWE - [CWE-483 - Incorrect Block Delimitation](https://cwe.mitre.org/data/definitions/483)