## Why is this an issue?

When exceptions occur, it is usually a bad idea to simply ignore them. Instead, it is better to handle them properly, or at least to log them.

This rule only reports on empty catch clauses that catch generic `Exception`s.

### Noncompliant code example

    string text = "";
    try
    {
        text = File.ReadAllText(fileName);
    }
    catch (Exception exc) // Noncompliant
    {
    }

### Compliant solution

    string text = "";
    try
    {
        text = File.ReadAllText(fileName);
    }
    catch (Exception exc)
    {
        logger.Log(exc);
    }

### Exceptions

When a block contains a comment, it is not considered to be empty.

## Resources

- OWASP - [Top 10 2021 Category A9 - Security Logging and
  Monitoring Failures](https://owasp.org/Top10/A09_2021-Security_Logging_and_Monitoring_Failures/)
- OWASP - [Top 10 2017 Category A10 -
  Insufficient Logging & Monitoring](https://owasp.org/www-project-top-ten/2017/A10_2017-Insufficient_Logging%2526Monitoring)
- CWE - [CWE-390 - Detection of Error Condition Without Action](https://cwe.mitre.org/data/definitions/390)