## Why is this an issue?

Non-encoded [control characters](https://en.wikipedia.org/wiki/Control_character) and whitespace characters are often injected in the
source code because of a bad manipulation. They are either invisible or difficult to recognize, which can result in bugs when the string is not what
the developer expects. If you actually need to use a control character use their encoded version:

- [ASCII](https://en.wikipedia.org/wiki/ASCII), for example `\n` and `\t`
- [Unicode](https://en.wikipedia.org/wiki/Unicode), for example `U+000D` and `U+0009`

This rule raises an issue when the following characters are seen in a [string literal](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/strings/):

- [ASCII control character](https://en.wikipedia.org/wiki/ASCII#Control_characters). (character index &lt; 32 or = 127)
- Unicode [whitespace characters](https://en.wikipedia.org/wiki/Unicode_character_property#Whitespace).
- Unicode [C0 control characters](https://en.wikipedia.org/wiki/C0_and_C1_control_codes)
- Unicode characters `U+200B, U+200C, U+200D, U+2060, U+FEFF, U+2028, U+2029`

### Exceptions

- [Verbatim string literals](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/strings/#verbatim-string-literals) and
  [raw string literals](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/strings/#raw-string-literals), since they have no
  escape mechanism
- The simple space character: Unicode `U+0020`, ASCII 32

## How to fix it

### Code examples

#### Noncompliant code example

    string tabInside = "A	B";                 // Noncompliant: contains a tabulation
    string zeroWidthSpaceInside = "foo​bar";     // Noncompliant: contains a U+200B character inside
    Console.WriteLine(zeroWidthSpaceInside);    // Prints "foo?bar"

#### Compliant solution

    string tabInside = "A\tB";                      // Compliant: escaped value
    string zeroWidthSpaceInside = "foo\u200Bbar";   // Compliant: escaped value
    Console.WriteLine(zeroWidthSpaceInside);        // Prints "foo?bar"

## Resources

### Documentation

- [Strings and string literals](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/strings/)
- [Control character](https://en.wikipedia.org/wiki/Control_character)