## Why is this an issue?

Certain [bitwise operations](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators)
are not needed and should not be performed because their results are predictable.

Specifically, using `& -1` with any value always results in the original value.

That is because the binary representation of `-1` on a [integral numeric type](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/integral-numeric-types) supporting
negative numbers, such as `int` or `long`, is based on [two’s
complement](https://en.wikipedia.org/wiki/Two%27s_complement) and made of all 1s: `0b111…​111`.

Performing `&` between a value and `0b111…​111` means applying the `&` operator to each bit of the value
and the bit `1`, resulting in a value equal to the provided one, bit by bit.

    anyValue & -1 // Noncompliant
    anyValue      // Compliant

Similarly, `anyValue | 0` always results in `anyValue`, because the binary representation of `0` is always
`0b000…​000` and the `|` operator returns its first input when the second is `0`.

    anyValue | 0  // Noncompliant
    anyValue      // Compliant

The same applies to `anyValue ^ 0`: the `^` operator returns `1` when its two input bits are different
(`1` and `0` or `0` and `1`) and returns `0` when its two input bits are the same (both
`0` or both `1`). When `^` is applied with `0`, the result would be `1` if the other input is
`1`, because the two input bits are different, and `0` if the other input bit is `0`, because the two input are the
same. That results in returning `anyValue`.

    anyValue ^ 0  // Noncompliant
    anyValue      // Compliant

## Resources

### Documentation

- [Bitwise operations (C#
  reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators)
- [And Operator (Visual Basic)](https://learn.microsoft.com/en-us/dotnet/visual-basic/language-reference/operators/and-operator)
- [Or Operator (Visual Basic)](https://learn.microsoft.com/en-us/dotnet/visual-basic/language-reference/operators/or-operator)
- [Xor Operator (Visual Basic)](https://learn.microsoft.com/en-us/dotnet/visual-basic/language-reference/operators/xor-operator)
- [Integral numeric types (C#
  reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/integral-numeric-types)
- [Numeric Data
  Types (Visual Basic)](https://learn.microsoft.com/en-us/dotnet/visual-basic/programming-guide/language-features/data-types/numeric-data-types)
- [Two’s complement](https://en.wikipedia.org/wiki/Two%27s_complement)

### Articles & blog posts

- [Stack Overflow - Are there any Bitwise Operator
  Laws?](https://stackoverflow.com/questions/12764670/are-there-any-bitwise-operator-laws)