## Why is this an issue?

`public static` mutable fields of classes which are accessed directly should be protected to the degree possible. This can be done by
reducing the accessibility of the field or by changing the return type to an immutable type.

This rule raises issues for `public static` fields with a type inheriting/implementing `System.Array` or
`System.Collections.Generic.ICollection<T>`.

### Noncompliant code example

    public class A
    {
        public static string[] strings1 = {"first","second"};  // Noncompliant
        public static List<String> strings3 = new List<String>();  // Noncompliant
    }

### Compliant solution

    public class A
    {
        protected static string[] strings1 = {"first","second"};
        protected static List<String> strings3 = new List<String>();
    }

### Exceptions

No issue is reported:

- If the type of the field inherits/implements one (at least) of the following types:
    - [`System.Collections.ObjectModel.ReadOnlyCollection<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.objectmodel.readonlycollection-1)
    - [`System.Collections.ObjectModel.ReadOnlyDictionary<TKey, TValue>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.objectmodel.readonlydictionary-2)
    - [`System.Collections.Frozen.FrozenDictionary<TKey, TValue>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.frozen.frozendictionary-2)
    - [`System.Collections.Frozen.FrozenSet<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.frozen.frozenset-1)
    - [`System.Collections.Immutable.ImmutableArray<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.immutablearray-1)
    - [`System.Collections.Immutable.IImmutableDictionary<TKey, TValue>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutabledictionary-2)
    - [`System.Collections.Immutable.IImmutableList<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablelist-1)
    - [`System.Collections.Immutable.IImmutableSet<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutableset-1)
    - [`System.Collections.Immutable.IImmutableStack<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablestack-1)
    - [`System.Collections.Immutable.IImmutableQueue<T>`](https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable.iimmutablequeue-1)
- If the field is `readonly` and is initialized inline with an immutable type (i.e. inherits/implements one of the types in the
  previous list) or null.

## Resources

- CWE - [CWE-582 - Array Declared Public, Final, and Static](https://cwe.mitre.org/data/definitions/582)
- CWE - [CWE-607 - Public Static Final Field References Mutable Object](https://cwe.mitre.org/data/definitions/607)