## Why is this an issue?

Property getters should be simple operations that are always safe to call. If exceptions need to be thrown, it is best to convert the property to a
method.

It is valid to throw exceptions from indexed property getters and from property setters, which are not detected by this rule.

### Noncompliant code example

    public int Foo
    {
        get
        {
            throw new Exception(); // Noncompliant
        }
    }

### Compliant solution

    public int Foo
    {
        get
        {
            return 42;
        }
    }

### Exceptions

No issue is raised when the thrown exception derives from or is of type `NotImplementedException`, `NotSupportedException` or
`InvalidOperationException`.