## Why is this an issue?

Constant members are copied at compile time to the call sites, instead of being fetched at runtime.

As an example, say you have a library with a constant `Version` member set to `1.0`, and a client application linked to it.
This library is then updated and `Version` is set to `2.0`. Unfortunately, even after the old DLL is replaced by the new one,
`Version` will still be `1.0` for the client application. In order to see `2.0`, the client application would need to
be rebuilt against the new version of the library.

This means that you should use constants to hold values that by definition will never change, such as `Zero`. In practice, those cases
are uncommon, and therefore it is generally better to avoid constant members.

This rule only reports issues on public constant fields, which can be reached from outside the defining assembly.

### Noncompliant code example

    public class Foo
    {
        public const double Version = 1.0;           // Noncompliant
    }

### Compliant solution

    public class Foo
    {
        public static double Version
        {
          get { return 1.0; }
        }
    }