## Why is this an issue?

Unnecessary keywords simply clutter the code and should be removed. Specifically:

- `partial` on type declarations that are completely defined in one place
- `sealed` on members of `sealed` classes
- `unsafe` method or block inside construct already marked with `unsafe`, or when there are no `unsafe`
  constructs in the block
- `checked` and `unchecked` blocks with no integral-type arithmetic operations

### Noncompliant code example

    public partial class MyClass // Noncompliant
    {
      public virtual void Method()
      {
      }
    }
    
    public sealed class MyOtherClass : MyClass
    {
      public sealed override void Method() // Noncompliant
      {
      }
    }

### Compliant solution

    public class MyClass
    {
      public virtual void Method()
      {
      }
    }
    
    public sealed class MyOtherClass : MyClass
    {
      public override void Method()
      {
      }
    }