## Why is this an issue?

`GetHashCode` is used to file an object in a `Dictionary` or `Hashtable`. If `GetHashCode` uses
non-`readonly` fields and those fields change after the object is stored, the object immediately becomes mis-filed in the
`Hashtable`. Any subsequent test to see if the object is in the `Hashtable` will return a false negative.

### Exceptions

This rule does not raise if the type implementing `GetHashCode` is a value type, for example a `struct` or a `record
struct`, since when a value type is stored in a `Dictionary` or `Hashtable`, a copy of the value is stored, not a
reference to the value.

## How to fix it

### Code examples

#### Noncompliant code example

    public class Person
    {
      public int age;
      public string name;
    
      public override int GetHashCode()
      {
        int hash = 12;
        hash += this.age.GetHashCode(); // Noncompliant
        hash += this.name.GetHashCode(); // Noncompliant
        return hash;
      }

#### Compliant solution

    public class Person
    {
      public readonly DateTime birthday;
      public string name;
    
      public override int GetHashCode()
      {
        int hash = 12;
        hash += this.birthday.GetHashCode();
        return hash;
      }