## Why is this an issue?

Type parameters that aren’t used are dead code, which can only distract and possibly confuse developers during maintenance. Therefore, unused type
parameters should be removed.

### Noncompliant code example

    public class MoreMath<T>   // Noncompliant; <T> is ignored
    {
      public int Add<T>(int a, int b) // Noncompliant; <T> is ignored
      {
        return a + b;
      }
    }

### Compliant solution

    public class MoreMath
    {
      public int Add (int a, int b)
      {
        return a + b;
      }
    }