## Why is this an issue?

Since C# 5.0, `async` and `await` are [contextual keywords](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/#contextual-keywords). Contextual keywords
do have a particular meaning in some contexts, but are not reserved and therefore can be used as variable names.

    int await = 42; // Noncompliant, but compiles
    int async = 42; // Noncompliant, but compiles

[Keywords](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords), on the other hand, are always reserved and
therefore are not valid variable names.

    int abstract = 42; // Error CS1585: Member modifier 'abstract' must precede the member type and name
    int foreach = 42; // Error CS1519: Invalid token 'foreach' in class, struct, or interface member declaration

To avoid any confusion, it is best to not use `async` and `await` as identifiers.

    int someVariableName = 42;
    int someOtherVariableName = 42;

## Resources

### Documentation

- [Contextual Keywords - MSDN](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/#contextual-keywords)
- [Asynchronous programming - MSDN](https://learn.microsoft.com/en-us/dotnet/csharp/asynchronous-programming/)