Using cookies is security-sensitive. It has led in the past to the following vulnerabilities:
 
-	    [CVE-2018-11639](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-11639)
-	    [CVE-2016-6537](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2016-6537)

Attackers can use widely-available tools to read cookies. Any sensitive information they may contain will be exposed.
 
This rule flags code that writes cookies.
 
## Ask Yourself Whether

-	    sensitive information is stored inside the cookie.

You are at risk if you answered yes to this question.
 
## Recommended Secure Coding Practices
 
Cookies should only be used to manage the user session. The best practice is to keep all user-related information server-side and link them to the user session, never sending them to the client. In a very few corner cases, cookies can be used for non-sensitive information that need to live longer than the user session.
 
Do not try to encode sensitive information in a non human-readable format before writing them in a cookie. The encoding can be reverted and the original information will be exposed.
 
Using cookies only for session IDs doesn’t make them secure. Follow [OWASP best practices](https://www.owasp.org/index.php/Session_Management_Cheat_Sheet#Cookies) when you configure your cookies.
 
As a side note, every information read from a cookie should be [Sanitized](https://www.owasp.org/index.php/Input_Validation_Cheat_Sheet).
 
## Sensitive Code Example

    // === .Net Framework ===
    
    HttpCookie myCookie = new HttpCookie("UserSettings");
    myCookie["CreditCardNumber"] = "1234 1234 1234 1234"; // Sensitive; sensitive data stored
    myCookie.Values["password"] = "5678"; // Sensitive
    myCookie.Value = "mysecret"; // Sensitive
    ...
    Response.Cookies.Add(myCookie);

    // === .Net Core ===
    
    Response.Headers.Add("Set-Cookie", ...); // Sensitive
    Response.Cookies.Append("mykey", "myValue"); // Sensitive

## See

-	    [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure
-	    [MITRE, CWE-312](https://cwe.mitre.org/data/definitions/312) - Cleartext Storage of Sensitive Information
-	    [MITRE, CWE-315](https://cwe.mitre.org/data/definitions/315) - Cleartext Storage of Sensitive Information in a Cookie
-	    Derived from FindSecBugs rule [COOKIE\_USAGE](https://find-sec-bugs.github.io/bugs.htm#COOKIE_USAGE)

## Deprecated
 
This rule is deprecated, and will eventually be removed.