## Why is this an issue?

A [`for`](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement) loop
is a fundamental programming construct used to execute a block of code repeatedly. However, if the loop’s condition is false before the first
iteration, the loop will never execute.

    for (int i = 0; i < 0; i++)  // Noncompliant: the condition is always false, the loop will never execute
    {
        // ...
    }

Rewrite the loop to ensure the condition evaluates to `true` at least once.

    for (int i = 0; i < 10; i++)  // Compliant: the condition is true at least once, the loop will execute
    {
        // ...
    }

This bug has the potential to cause unexpected outcomes as the loop might contain critical code that needs to be executed.

## Resources

### Documentation

- Microsoft Learn - [The `for`
  statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement)