## Why is this an issue?

A `for` loop with a counter that moves in the wrong direction, away from the stop condition, is not an infinite loop. Because of [wraparound](https://en.wikipedia.org/wiki/Integer_overflow#:~:text=The%20most%20common%20result%20of%20an%20overflow%20is%20that%20the%20least%20significant%20representable%20digits%20of%20the%20result%20are%20stored%3B%20the%20result%20is%20said%20to%20wrap%20around%20the%20maximum),
the loop will eventually reach its stop condition, but in doing so, it will probably run more times than anticipated, potentially causing unexpected
behavior.

## How to fix it

If your [stop
condition](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement:~:text=The%20condition%20section%20that%20determines%20if%20the%20next%20iteration%20in%20the%20loop%20should%20be%20executed) indicates a **maximum** value, the [iterator](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement:~:text=The%20iterator%20section%20that%20defines%20what%20happens%20after%20each%20execution%20of%20the%20body%20of%20the%20loop)
should **increase** towards it. Conversely, if your stop condition indicates a **minimum** value, the iterator should
**decrease** towards it.

### Code examples

#### Noncompliant code example

    for (int i = 0; i < maximum; i--)  // Noncompliant: runs until it underflows to int.MaxValue
    {
        // ...
    }
    
    for (int i = maximum; i >= maximum; i++)  // Noncompliant: runs until it overflows to int.MinValue
    {
        // ...
    }

#### Compliant solution

    for (int i = 0; i < maximum; i++) // Compliant: Increment towards the maximum value
    {
    }
    
    for (int i = maximum; i >= 0; i--) // Compliant: Decrement towards the minimum value
    {
        // ...
    }

## Resources

### Documentation

- [Integer overflow](https://en.wikipedia.org/wiki/Integer_overflow)
- [The
  `for` statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement)