## Why is this an issue?

Calling [ToString()](https://learn.microsoft.com/en-us/dotnet/api/system.object.tostring) on an object should always return a
`string`. Thus, [overriding the
ToString method](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/how-to-override-the-tostring-method) should never return `null`, as it breaks the method’s implicit contract, and as a result the consumer’s
expectations.

    public override string ToString ()
    {
      if (this.collection.Count == 0)
      {
        return null; // Noncompliant
      }
      else
      {
        // ...
      }
    }

A better alternative is to use the [String.Empty](https://learn.microsoft.com/en-us/dotnet/api/system.string.empty) built-in field.

    public override string ToString ()
    {
      if (this.collection.Count == 0)
      {
        return string.Empty;
      }
      else
      {
        // ...
      }
    }

## Resources

### Documentation

- CWE - [CWE-476 - NULL Pointer Dereference](https://cwe.mitre.org/data/definitions/476)
- [Object.ToString Method](https://learn.microsoft.com/en-us/dotnet/api/system.object.tostring)
- [How to
  override the ToString method](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/how-to-override-the-tostring-method)