## Why is this an issue?

Certain [mathematical comparisons](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators)
will always return the same value, and should not be performed.

Specifically, the following comparisons will return either always `true` or always `false` depending on the kind of
comparison:

- comparing a `char` with a numeric constant that is outside of the range of `char`
- comparing a `float` with a numeric constant that is outside of the range of `float`
- comparing a `long` with a numeric constant that is outside of the range of `long`
- comparing a `ulong` with a numeric constant that is outside of the range of `ulong`
- etc.

### Noncompliant code example

    float f = 42.0f;
    if (f <= double.MaxValue) { } // Noncompliant: always true
    if (f > double.MaxValue) { }  // Noncompliant: always false

## Resources

### Documentation

- Microsoft Learn: [Comparison
  operators (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators)
- Microsoft Learn: [Ranges for integral numeric types (C# reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/integral-numeric-types#characteristics-of-the-integral-types)
- Microsoft Learn: [Range for char (C#
  reference)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/builtin-types/char)