## Why is this an issue?

When the modulus of a negative number is calculated, the result will either be negative or zero. Thus, comparing the modulus of a variable for
equality with a positive number (or a negative one) could result in unexpected results.

### Noncompliant code example

    public bool IsOdd(int x)
    {
      return x % 2 == 1;  // Noncompliant; if x is an odd negative, x % 2 == -1
    }

### Compliant solution

    public bool IsOdd(int x)
    {
      return x % 2 != 0;
    }

or

    public bool IsOdd(uint x)
    {
      return x % 2 == 1;
    }