## Why is this an issue?

When division is performed on `int`s, the result will always be an `int`. You can assign that result to a
`double`, `float` or `decimal` with automatic type conversion, but having started as an `int`, the result
will likely not be what you expect. If the result of `int` division is assigned to a floating-point variable, precision will have been lost
before the assignment. Instead, at least one operand should be cast or promoted to the final type before the operation takes place.

### Noncompliant code example

    static void Main()
    {
      decimal dec = 3/2; // Noncompliant
      Method(3/2); // Noncompliant
    }
    
    static void Method(float f) { }

### Compliant solution

    static void Main()
    {
      decimal dec = (decimal)3/2;
      Method(3.0F/2);
    }
    
    static void Method(float f) { }

## Resources

### Standards

- CWE - [CWE-190 - Integer Overflow or Wraparound](https://cwe.mitre.org/data/definitions/190)
- STIG Viewer - [Application Security and
  Development: V-222612](https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222612) - The application must not be vulnerable to overflow attacks.