## Why is this an issue?

The difference between `private` and `protected` visibility is that child classes can see and use `protected`
members, but they cannot see `private` ones. Since a `sealed` class cannot have children, marking its members
`protected` is confusingly pointless.

### Noncompliant code example

    public sealed class MySealedClass
    {
        protected string name = "Fred";  // Noncompliant
        protected void SetName(string name) // Noncompliant
        {
            // ...
        }
    }

### Compliant solution

    public sealed class MySealedClass
    {
        private string name = "Fred";
        public void SetName(string name)
        {
            // ...
        }
    }