## Why is this an issue?

Beginning with C# 7, it is possible to add underscores ('\_') to numeric literals to enhance readability. The addition of underscores in this manner
has no semantic meaning, but makes it easier for maintainers to understand the code.

The number of digits to the left of a decimal point needed to trigger this rule varies by base.

| Base | Minimum digits |
| --- | --- |
| binary | 9 |
| decimal | 6 |
| hexadecimal | 9 |

It is only the presence of underscores, not their spacing that is scrutinized by this rule.

**Note** that this rule is automatically disabled when the project’s `C# version` is lower than `7`.

### Noncompliant code example

    int i = 10000000;  // Noncompliant; is this 10 million or 100 million?
    int  j = 0b01101001010011011110010101011110;  // Noncompliant
    long l = 0x7fffffffffffffffL;  // Noncompliant

### Compliant solution

    int i = 10_000_000;
    int  j = 0b01101001_01001101_11100101_01011110;
    long l = 0x7fff_ffff_ffff_ffffL;