## Why is this an issue?

Passing a collection as an argument to the collection’s own method is a code defect. Doing so might either have unexpected side effects or always
have the same result.

Another case is using set-like operations. For example, using [Union](https://learn.microsoft.com/en-us/dotnet/api/system.linq.enumerable.union) between a list and itself will always return the same list.
Conversely, using [Except](https://learn.microsoft.com/en-us/dotnet/api/system.linq.enumerable.except) between a list and itself will
always return an empty list.

    var list = new List<int>();
    
    list.AddRange(list);          // Noncompliant
    list.Concat(list);            // Noncompliant
    
    list.Union(list);             // Noncompliant: always returns list
    list.Intersect(list);         // Noncompliant: always returns list
    list.Except(list);            // Noncompliant: always returns empty
    list.SequenceEqual(list);     // Noncompliant: always returns true
    
    var set = new HashSet<int>();
    set.UnionWith(set);           // Noncompliant: no changes
    set.IntersectWith(set);       // Noncompliant: no changes
    set.ExceptWith(set);          // Noncompliant: always returns empty
    set.SymmetricExceptWith(set); // Noncompliant: always returns empty
    set.IsProperSubsetOf(set);    // Noncompliant: always returns false
    set.IsProperSupersetOf(set);  // Noncompliant: always returns false
    set.IsSubsetOf(set);          // Noncompliant: always returns true
    set.IsSupersetOf(set);        // Noncompliant: always returns true
    set.Overlaps(set);            // Noncompliant: always returns true
    set.SetEquals(set);           // Noncompliant: always returns true

## Resources

### Documentation

- [Collections](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/concepts/collections)