## Why is this an issue?

There is no good excuse for an empty class. If it’s being used simply as a common extension point, it should be replaced with an
`interface`. If it was stubbed in as a placeholder for future development it should be fleshed-out. In any other case, it should be
eliminated.

### Noncompliant code example

    public class Empty // Noncompliant
    {
    }

### Compliant solution

    public interface IEmpty
    {
    }

### Exceptions

- Partial classes are ignored entirely, as source generators often use them.
- Classes with names ending in `Command`, `Message`, `Event`, or `Query` are ignored as messaging
  libraries often use them.
- Subclasses of `System.Exception` are ignored; even an empty Exception class can provide helpful information by its type name alone.
- Subclasses of `System.Attribute` and classes annotated with attributes are ignored.
- Subclasses of generic classes are ignored, as they can be used for type specialization even when empty.
- Subclasses of certain framework types — like the `PageModel` class used in ASP.NET Core Razor Pages — are ignored.
- Subclass of a class with non-public default constructors are ignored, as they widen the constructor accessibility.

    using Microsoft.AspNetCore.Mvc.RazorPages;
    
    public class EmptyPageModel: PageModel // Compliant - an empty PageModel can be fully functional, the C# code can be in the cshtml file
    {
    }