When a cookie is protected with the `secure` attribute set to *true* it will not be send by the browser over an unencrypted HTTP
request and thus cannot be observed by an unauthorized person during a man-in-the-middle attack.

## Ask Yourself Whether

- the cookie is for instance a *session-cookie* not designed to be sent over non-HTTPS communication.
- it’s not sure that the website contains [mixed content](https://developer.mozilla.org/en-US/docs/Web/Security/Mixed_content) or not
  (ie HTTPS everywhere or not)

There is a risk if you answered yes to any of those questions.

## Recommended Secure Coding Practices

- It is recommended to use `HTTPs` everywhere so setting the `secure` flag to *true* should be the default behaviour
  when creating cookies.
- Set the `secure` flag to *true* for session-cookies.

## Sensitive Code Example

When the `HttpCookie.Secure` property is set to `false` then the cookie will be send during an unencrypted HTTP request:

    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.Secure = false; //  Sensitive: a security-sensitive cookie is created with the secure flag set to false

The [default value](https://docs.microsoft.com/en-us/dotnet/api/system.web.httpcookie.secure?view=netframework-4.8) of
`Secure` flag is `false`, unless overwritten by an application’s configuration file:

    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    //  Sensitive: a security-sensitive cookie is created with the secure flag not defined (by default set to false)

## Compliant Solution

Set the `HttpCookie.Secure` property to `true`:

    HttpCookie myCookie = new HttpCookie("Sensitive cookie");
    myCookie.Secure = true; // Compliant

Or change the default flag values for the whole application by editing the [Web.config configuration file](https://docs.microsoft.com/en-us/previous-versions/dotnet/netframework-4.0/ms228262%28v=vs.100%29):

    <httpCookies httpOnlyCookies="true" requireSSL="true" />

- the `requireSSL` attribute corresponds programmatically to the `Secure` field.
- the `httpOnlyCookies` attribute corresponds programmatically to the `httpOnly` field.

## See

- OWASP - [Top 10 2021 Category A4 - Insecure Design](https://owasp.org/Top10/A04_2021-Insecure_Design/)
- OWASP - [Top 10 2021 Category A5 - Security Misconfiguration](https://owasp.org/Top10/A05_2021-Security_Misconfiguration/)
- OWASP - [Top 10 2017 Category A3 - Sensitive Data
  Exposure](https://owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure)
- CWE - [CWE-311 - Missing Encryption of Sensitive Data](https://cwe.mitre.org/data/definitions/311)
- CWE - [CWE-315 - Cleartext Storage of Sensitive Information in a Cookie](https://cwe.mitre.org/data/definitions/315)
- CWE - [CWE-614 - Sensitive Cookie in HTTPS Session Without 'Secure' Attribute](https://cwe.mitre.org/data/definitions/614)
- STIG Viewer - [Application Security and
  Development: V-222576](https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222576) - The application must set the secure flag on session cookies.