## Why is this an issue?

When the same code is duplicated in two or more separate branches of a conditional, it can make the code harder to understand, maintain, and can
potentially introduce bugs if one instance of the code is changed but others are not.

Having two `cases` in a `switch` statement or two branches in an `if` chain with the same implementation is at
best duplicate code, and at worst a coding error.

    if (a >= 0 && a < 10)
    {
      DoFirst();
      DoTheThing();
    }
    else if (a >= 10 && a < 20)
    {
      DoTheOtherThing();
    }
    else if (a >= 20 && a < 50) // Noncompliant; duplicates first condition
    {
      DoFirst();
      DoTheThing();
    }

    switch (i)
    {
      case 1:
        DoFirst();
        DoSomething();
        break;
      case 2:
        DoSomethingDifferent();
        break;
      case 3:  // Noncompliant; duplicates case 1's implementation
        DoFirst();
        DoSomething();
        break;
      default:
        DoTheRest();
    }

If the same logic is truly needed for both instances, then:

- in an `if` chain they should be combined

    if ((a >= 0 && a < 10) || (a >= 20 && a < 50))
    {
      DoFirst();
      DoTheThing();
    }
    else if (a >= 10 && a < 20)
    {
      DoTheOtherThing();
    }

- for a `switch`, one should fall through to the other

    switch (i)
    {
      case 1:
      case 3:
        DoFirst();
        DoSomething();
        break;
      case 2:
        DoSomethingDifferent();
        break;
      default:
        DoTheRest();
    }

### Exceptions

The rule does not raise an issue for blocks in an `if` chain that contain a single line of code. The same applies to blocks in a
`switch` statement that contain a single line of code with or without a following `break`.

    if (a >= 0 && a < 10)
    {
      DoTheThing();
    }
    else if (a >= 10 && a < 20)
    {
      DoTheOtherThing();
    }
    else if (a >= 20 && a < 50)    //no issue, usually this is done on purpose to increase the readability
    {
      DoTheThing();
    }

However, this exception does not apply to `if` chains without an `else` statement or to a `switch` statement
without a `default` clause.

    if (a == 1)
    {
      DoSomething();  // Noncompliant, this might have been done on purpose but probably not
    }
    else if (a == 2)
    {
      DoSomething();
    }

## Resources

### Related rules

- {rule:csharpsquid:S3923} - All branches in a conditional structure should not have exactly the same implementation