## Why is this an issue?

A chain of [if/else
if](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement) statements is evaluated from top to bottom. At most, only one branch will be executed: the first statement with a condition that evaluates to
`true`. Therefore, duplicating a condition leads to unreachable code inside the duplicated condition block. Usually, this is due to a
copy/paste error.

The result of such duplication can lead to unreachable code or even to unexpected behavior.

## How to fix it

### Code examples

#### Noncompliant code example

    if (param == 1)
    {
      OpenWindow();
    }
    else if (param == 2)
    {
      CloseWindow();
    }
    else if (param == 1) // Noncompliant: condition has already been checked
    {
      MoveWindowToTheBackground(); // unreachable code
    }

#### Compliant solution

    if (param == 1)
    {
      OpenWindow();
    }
    else if (param == 2)
    {
      CloseWindow();
    }
    else if (param == 3)
    {
      MoveWindowToTheBackground();
    }

## Resources

### Documentation

- [The if
  statement](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/selection-statements#the-if-statement)