## Why is this an issue?

Using the same value on both sides of certain operators is a code defect. In the case of logical operators, it is either a copy/paste error and,
therefore, a bug, or it is simply duplicated code and should be simplified. For bitwise operators and most binary mathematical operators, having the
same value on both sides of an operator yields predictable results and should be simplified as well to avoid further code defects.

This rule raises for the following operators.

- [Equality operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators)
  (`==` and `!=`)
- [Comparison operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators)
  (`< =`, `<`, `>`, `>=`)
- The following [Logical
  Operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/boolean-logical-operators):
    - Logical OR (`|` )
    - Conditional logical OR (`||`)
    - Logical AND (`&`)
    - Conditional logical AND (`&&`)
    - Logical exclusive OR (`^`)
- The following [arithmetic
  operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/arithmetic-operators):
    - Subtraction (`-`)
    - Division (`\`)
    - Remainder operator (`%`)
    - Subtraction assignment operator (`-=`)
    - Divide assignment operator (`\=`)

### Exceptions

This rule ignores the following operators:

- Multiplication (\*)
- Addition (+)
- Assignment (=)
- [Left-shift
  (&lt;&lt;)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#left-shift-operator-)
- [Right-shift
  (&gt;&gt;)](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators#right-shift-operator-)

### Code examples

#### Noncompliant code example

    if ( a == a ) // always true
    {
      doZ();
    }
    if ( a != a ) // always false
    {
      doY();
    }
    if ( a == b && a == b ) // if the first one is true, the second one is too
    {
      doX();
    }
    if ( a == b || a == b ) // if the first one is true, the second one is too
    {
      doW();
    }
    
    int j = 5 / 5; // always 1
    int k = 5 - 5; // always 0
    
    c.Equals(c);    // always true
    Object.Equals(c, c); // always true

## Resources

### Documentation

- [Arithmetic Operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/arithmetic-operators)
- [Boolean logical operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/boolean-logical-operators)
- [Bitwise and shift
  operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/bitwise-and-shift-operators)
- [Equality operators - test if two
  objects are equal or not](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators)
- [Comparison operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators)
- [Assignment operators](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/assignment-operator)