## Why is this an issue?

Re-assigning a variable to itself is a defect as it has no actual effect and indicates meaning to do something else. It usually means that:

- The statement is redundant and should be removed
- The re-assignment is a mistake, and another value or variable was intended for the assignment instead

### Code examples

#### Noncompliant code example

    public class Choice {
        private bool selected;
    
        public void MakeChoice(bool selected)
        {
            selected = selected; // Noncompliant
        }
    }

#### Compliant solution

    public class Choice {
        private bool selected;
    
        public void MakeChoice(bool selected)
        {
            this.selected = selected; // Compliant
        }
    }

## Resources

### Documentation

- Microsoft Learn - [Compiler Warning (level 3) CS1717](https://learn.microsoft.com/en-us/dotnet/csharp/misc/cs1717)