## Why is this an issue?

`StringBuilder` is more efficient than string concatenation, especially when the operator is repeated over and over as in loops.

### Noncompliant code example

    string str = "";
    for (int i = 0; i < arrayOfStrings.Length ; ++i)
    {
      str = str + arrayOfStrings[i];
    }

### Compliant solution

    StringBuilder bld = new StringBuilder();
    for (int i = 0; i < arrayOfStrings.Length; ++i)
    {
      bld.Append(arrayOfStrings[i]);
    }
    string str = bld.ToString();