## Why is this an issue?

An unused local variable is a variable that has been declared but is not used anywhere in the block of code where it is defined. It is dead code,
contributing to unnecessary complexity and leading to confusion when reading the code. Therefore, it should be removed from your code to maintain
clarity and efficiency.

### What is the potential impact?

Having unused local variables in your code can lead to several issues:

- **Decreased Readability**: Unused variables can make your code more difficult to read. They add extra lines and complexity, which
  can distract from the main logic of the code.
- **Misunderstanding**: When other developers read your code, they may wonder why a variable is declared but not used. This can lead
  to confusion and misinterpretation of the code’s intent.
- **Potential for Bugs**: If a variable is declared but not used, it might indicate a bug or incomplete code. For example, if you
  declared a variable intending to use it in a calculation, but then forgot to do so, your program might not work as expected.
- **Maintenance Issues**: Unused variables can make code maintenance more difficult. If a programmer sees an unused variable, they
  might think it is a mistake and try to 'fix' the code, potentially introducing new bugs.
- **Memory Usage**: Although modern compilers are smart enough to ignore unused variables, not all compilers do this. In such cases,
  unused variables take up memory space, leading to inefficient use of resources.

In summary, unused local variables can make your code less readable, more confusing, and harder to maintain, and they can potentially lead to bugs
or inefficient memory use. Therefore, it is best to remove them.

### Exceptions

Unused locally created resources in a `using` statement are not reported.

    using(var t = new TestTimer()) // t never used, but compliant.
    {
      //...
    }

## How to fix it

The fix for this issue is straightforward. Once you ensure the unused variable is not part of an incomplete implementation leading to bugs, you
just need to remove it.

### Code examples

#### Noncompliant code example

    public int NumberOfMinutes(int hours)
    {
      int seconds = 0;   // Noncompliant - seconds is unused
      return hours * 60;
    }

#### Compliant solution

    public int NumberOfMinutes(int hours)
    {
      return hours * 60;
    }