## Why is this an issue?

Nested control flow statements `if`, `switch`, `for`, `foreach`, `while`, `do`,
and `try` are often key ingredients in creating what’s known as "Spaghetti code". This code smell can make your program difficult to
understand and maintain.

When numerous control structures are placed inside one another, the code becomes a tangled, complex web. This significantly reduces the code’s
readability and maintainability, and it also complicates the testing process.

## How to fix it

### Code examples

The following example demonstrates the behavior of the rule with the default threshold of 3 levels of nesting and one of the potential ways to fix
the code smell by introducing guard clauses:

#### Noncompliant code example

    if (condition1)                  // Compliant - depth = 1
    {
      /* ... */
      if (condition2)                // Compliant - depth = 2
      {
        /* ... */
        for (int i = 0; i < 10; i++)  // Compliant - depth = 3
        {
          /* ... */
          if (condition4)            // Noncompliant - depth = 4, which exceeds the limit
          {
            if (condition5)          // Depth = 5, exceeding the limit, but issues are only reported on depth = 4
            {
              /* ... */
            }
            return;
          }
        }
      }
    }

#### Compliant solution

    if (!condition1)
    {
      return;
    }
    /* ... */
    if (!condition2)
    {
      return;
    }
    for (int i = 0; i < 10; i++)
    {
      /* ... */
      if (condition4)
      {
        if (condition5)
        {
          /* ... */
        }
        return;
      }
    }

## Resources

- [Guard clauses in programming](https://en.wikipedia.org/wiki/Guard_%28computer_science%29) - one of the approaches to reducing the depth
  of nesting